package net.saqoosha.geom {
	
	public class CubicBezier3D {
		
		private var _p0:Point3D;
		private var _p1:Point3D;
		private var _p2:Point3D;
		private var _p3:Point3D;
		
		public function CubicBezier3D(start:Point3D = null, control1:Point3D = null, control2:Point3D = null, end:Point3D = null) {
			this.start = start || new Point3D();
			this.control1 = control1 || new Point3D();
			this.control2 = control2 || new Point3D();
			this.end = end || new Point3D();;
		}
		
		public function getPointAt(t:Number, p:Point3D = null):Point3D {
			var t2:Number = t * t;
			var t3:Number = t2 * t;
			var g:Number;
			var b:Number;
			var a:Number;
			var ret:Point3D = p || new Point3D();
			// x
			g = 3 * (this._p1.x - this._p0.x);
			b = 3 * (this._p2.x - this._p1.x) - g;
			a = this._p3.x - this._p0.x - g - b;
			ret.x = a * t3 + b * t2 + g * t + this._p0.x;
			// y
			g = 3 * (this._p1.y - this._p0.y);
			b = 3 * (this._p2.y - this._p1.y) - g;
			a = this._p3.y - this._p0.y - g - b;
			ret.y = a * t3 + b * t2 + g * t + this._p0.y;
			// z
			g = 3 * (this._p1.z - this._p0.z);
			b = 3 * (this._p2.z - this._p1.z) - g;
			a = this._p3.z - this._p0.z - g - b;
			ret.z = a * t3 + b * t2 + g * t + this._p0.z;
			return ret;
		}
		
		public function getPointAt1(u:Number, p:Point3D = null):Point3D {
			var ret:Point3D = p || new Point3D();
			ret.x = u * u * u * (this._p3.x + 3 * (this._p1.x - this._p2.x) - this._p0.x)
					+ 3 * u * u * (this._p0.x - 2 * this._p1.x + this._p2.x)
					+ 3 * u * (this._p1.x - this._p0.x)
					+ this._p0.x ;
			ret.y = u * u * u * (this._p3.y + 3 * (this._p1.y - this._p2.y) - this._p0.y)
					+ 3 * u * u * (this._p0.y - 2 * this._p1.y + this._p2.y)
					+ 3 * u * (this._p1.y - this._p0.y)
					+ this._p0.y ;
			ret.z = u * u * u * (this._p3.z + 3 * (this._p1.z - this._p2.z) - this._p0.z)
					+ 3 * u * u * (this._p0.z - 2 * this._p1.z + this._p2.z)
					+ 3 * u * (this._p1.z - this._p0.z)
					+ this._p0.z ;
			return ret;
		}
		
		public function getPointAt2(t:Number, p:Point3D = null):Point3D {
			var ret:Point3D = p || new Point3D();
			var tt:Number = 1 - t;
			var t0:Number = tt * tt * tt;
			var t1:Number = 3 * tt * tt * t;
			var t2:Number = 3 * tt * t * t;
			var t3:Number = t * t * t;
			ret.x = t0 * this._p0.x + t1 * this._p1.x + t2 * this._p2.x + t3 * this._p3.x;
			ret.y = t0 * this._p0.y + t1 * this._p1.y + t2 * this._p2.y + t3 * this._p3.y;
			ret.z = t0 * this._p0.z + t1 * this._p1.z + t2 * this._p2.z + t3 * this._p3.z;
			return ret;
		}
		
		//
		public function get start():Point3D {
			return this._p0;
		}
		public function set start(value:Point3D):void {
			this._p0 = value;
		}
		
		//
		public function get control1():Point3D {
			return this._p1;
		}
		public function set control1(value:Point3D):void {
			this._p1 = value;
		}
		
		//
		public function get control2():Point3D {
			return this._p2;
		}
		public function set control2(value:Point3D):void {
			this._p2 = value;
		}
		
		//
		public function get end():Point3D {
			return this._p3;
		}
		public function set end(value:Point3D):void {
			this._p3 = value;
		}
		
		//
		public function toString():String {
			return '[CubicBezier3D \n' +
						'\t' + this.start + ',\n' + 
						'\t' + this.control1 + ',\n' + 
						'\t' + this.control2 + ',\n' + 
						'\t' + this.end + '\n' + 
					']';
		}
	}
}